//////////
//
//	File:		ComApplication.h
//
//	Contains:	Application-specific code for QuickTime movies demo.
//
//	Written by:	Tim Monroe
//				Based (heavily!) on the MovieShell code written by Apple DTS
//
//	Copyright:	 1994-1997 by Apple Computer, Inc., all rights reserved.
//
//	Change History (most recent first):
//
//	   <4>	 	09/11/97	rtm		merged MacApplication.h and WinApplication.h
//	   <3>	 	08/21/97	rtm		begun adding Windows support
//	   <2>	 	11/27/96	rtm		conversion to personal coding style
//	   <1>	 	12/21/94	khs		first file
//	   
//////////

#pragma once

//////////
// header files
//////////

#ifndef __QUICKTIMEVR__
#include <QuickTimeVR.h>
#endif

#ifndef __QTUtilities__
#include "QTUtilities.h"
#endif

#ifndef __QTVRUtilities__
#include "QTVRUtilities.h"
#endif

#include <TextUtils.h>
#include <string.h>

#if TARGET_OS_MAC
#include "MacFramework.h"
#include "AppConfiguration.h"
#endif	// TARGET_OS_MAC

#if TARGET_OS_WIN32
#include "WinFramework.h"
#endif	// TARGET_OS_WIN32

#include "ComResource.h"

//////////
// constants
//////////

//////////
// structures
//////////

// application-specific data
typedef struct {
	Movie						fMovie;				// the embedded movie to play
	GWorldPtr					fMovieGWorld;		// the offscreen graphics world used for imaging embedded movies
	PixMapHandle				fMoviePixMap;		// the pixmap of the offscreen graphics world
	QTVRFloatPoint				fMovieCenter;		// the center in the panorama of the movie screen (in angles: x = pan; y = tilt)
	Rect						fMovieRect;			// the height and width of the embedded movie (in coordinates)
	float						fMovieScale;		// a scale factor for the movie rectangle
	float						fMovieWidth;		// the width (in radians) of the embedded movie
	Boolean						fUseMovieGWorld;	// use the specified movie GWorld?
	Boolean						fUseMovieCenter;	// use the specified movie center?
	Boolean						fQTMovieHasSound;	// does the embedded movie have a sound track?
	Boolean						fCompositeMovie;	// does the embedded movie need to be composited?
	Boolean						fUseHideRegion;		// use the specified movie hide region?
	QTVRBackBufferImagingUPP	fBackBufferProc;	// a routine descriptor for our back buffer routine
	RGBColor					fChromaColor;		// the color for chroma key compositing
	RgnHandle					fHideRegion;		// the region that obscures the embedded movie
	MatrixRecord				fRotationMatrix;	// the matrix we use to (optionally) rotate the movie
	Boolean						fDrewOnPrevBBProc;	// did we draw the previous time thru our bb proc?
} ApplicationDataRecord, *ApplicationDataPtr, **ApplicationDataHdl;


// the function prototypes are in the file MacFramework.h or WinFramework.h